<?php
/* --------------------------------------------------------------
 CustomerName.php 2020-02-14
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Customer;

/**
 * Class CustomerName
 * @package Gambio\Admin\Customer
 */
class CustomerName
{
    /**
     * @var string
     */
    private $firstName;
    
    /**
     * @var string
     */
    private $lastName;
    
    
    /**
     * CustomerName constructor.
     *
     * @param string $firstName
     * @param string $lastName
     */
    private function __construct(string $firstName, string $lastName)
    {
        $this->firstName = $firstName;
        $this->lastName  = $lastName;
    }
    
    
    /**
     * Factory method for customer name.
     *
     * @param string $firstName
     * @param string $lastName
     *
     * @return static
     */
    public static function create(string $firstName, string $lastName): self
    {
        return new static($firstName, $lastName);
    }
    
    
    /**
     * @return string
     */
    public function firstName(): string
    {
        return $this->firstName;
    }
    
    
    /**
     * @return string
     */
    public function lastName(): string
    {
        return $this->lastName;
    }
}